<?xml version="1.0" encoding="UTF-8"?><!--
            Copyright
            2010 axYus - http://www.axyus.com
            2010 J.Leger - johann.leger@axyus.com

            This file is part of ODM print-comp.

            ODM print-comp is free software; you can redistribute it and/or modify
            it under the terms of the GNU Lesser General Public License as published by
            the Free Software Foundation; either version 2 of the License, or
            (at your option) any later version.

            ODM print-comp is distributed in the hope that it will be useful,
            but WITHOUT ANY WARRANTY; without even the implied warranty of
            MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
            GNU Lesser General Public License for more details.

            You should have received a copy of the GNU Lesser General Public License
            along with ODM print-comp; if not, write to the Free Software
            Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
        --><xsl:stylesheet xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:n="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:xad="http://uri.etsi.org/01903/v1.2.2#" xmlns:data="http://odm-budgetaire.org/data" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:date="http://exslt.org/dates-and-times" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:com="http://www.xemelios.org/namespaces#cg-1.0" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data"><xsl:import href="../../../../number.xsl"></xsl:import><xsl:import href="../../../../date.xsl"></xsl:import><xsl:import href="../../../../table.xsl"></xsl:import><xsl:import href="../../../../style.xsl"></xsl:import><xsl:import href="../../../../lien.xsl"></xsl:import><xsl:param name="HTML_OUTPUT_FORMAT"></xsl:param><xsl:param name="PDF_OUTPUT_FORMAT"></xsl:param><xsl:variable name="page-format" select="portrait"></xsl:variable><xsl:output encoding="UTF-8" method="xml" indent="yes"></xsl:output><xsl:variable name="docbudg" select="/dcfu:CompteFinancierUnique"></xsl:variable><xsl:param name="nomenclaturePasEnrichie"></xsl:param><xsl:variable name="nomenclature" select="$nomenclaturePasEnrichie/n:Nomenclature"></xsl:variable><xsl:variable name="data" select="document('../../libelleAffiche.xml')/data"></xsl:variable><xsl:variable name="isPrint" select="1"></xsl:variable><xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"></xsl:decimal-format><xsl:template match="*"></xsl:template><xsl:template match="dcfu:CompteFinancierUnique"><html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
   <head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" /><meta name="generator" content="ODM" />
      
      <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css" />
      <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css" />
      
      <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:SimSun;
  panose-1:2 1 6 0 3 1 1 1 1 1;}
@font-face
  {font-family:Mangal;
  panose-1:0 0 4 0 0 0 0 0 0 0;}
@font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:"\@SimSun";
  panose-1:2 1 6 0 3 1 1 1 1 1;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0cm;
  font-size:10.0pt;
  font-family:"Arial",sans-serif;}
p.Contenudetableau, li.Contenudetableau, div.Contenudetableau
  {
  margin:0cm;
  font-size:10.0pt;
  font-family:"Arial",sans-serif;}
.MsoChpDefault
  {font-family:"Calibri",sans-serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
@page{size:297mm 210mm;
  }
div.WordSection1
  {}
--&gt;
/**/
}</style></head>
   <body lang="FR" style="word-wrap:break-word"><div id="header">
         <xsl:variable name="varOdmTmpTab1"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none"><tr><td width="75%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p style="punctuation-wrap:simple"><span style="font-size: 10.0pt;font-family:&#34;Arial&#34;,sans-serif">
                        <xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@CodeBC)"/> – 
                        
                        
                        <xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Libelle)"/></span></p></td><td width="25%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p align="right" style="text-align:right;punctuation-wrap:simple"><span style="font-size:10.0pt;font-family:&#34;Arial&#34;,sans-serif">Exercice 
                        
                        
                        <xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V)"/></span></p></td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab1"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"><span style="font-size:4.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
      </div>
      
      <div class="WordSection1">
         <xsl:variable name="varOdmTmpTab2"><table width="100%" class="MsoNormalTable " border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse"><tr><td width="90%" valign="top" style="border:solid black 1.0pt; border-right:none;padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="line-height:115%"><xsl:variable name ="Refer4">ABILAN</xsl:variable><xsl:variable name ="Refer5" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Refer6" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="lien:reference"><xsl:with-param name="id" select="concat ($Refer4, '_', $Refer5, '_', $Refer6)"/></xsl:call-template></span><b>III – ÉTATS FINANCIERS</b></p>
               </td><td width="10%" valign="top" style="border:solid black 1.0pt; padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><b>III</b></p>
               </td></tr><tr><td width="90%" valign="top" style="border-top:none;border-left: solid black 1.0pt;border-bottom:solid black 1.0pt;border-right:none; padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><b><span style="line-height:115%">Bilan (en euros)</span></b></p>
               </td><td width="10%" valign="top" style="border:solid black 1.0pt; border-top:none;padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><b><span style="line-height:115%">A</span></b></p>
               </td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab2"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal" style="punctuation-wrap:simple"><span style="font-size:11.0pt"> </span></p>
         <xsl:variable name="varOdmTmpTab3"><table width="100%" class="MsoNormalTable BORDURE" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse"><xsl:variable name="varOdm1" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable[(./dc:Etat/@V='BI_A') and (./dc:ModeTraitement/@V!='NOTE_BAS_PAGE')]"/><thead>
               <tr style="height:15.55pt"><xsl:variable name="varOdm2" select="$varOdm1"/><xsl:variable name="content9">
                     <span><b>ACTIF</b></span>
                     <span></span>
                  </xsl:variable><xsl:variable name="className18">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className18" /><xsl:with-param name="rowspan">2</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">44.9%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content9" /></xsl:call-template><xsl:variable name="content10">
                     <b><span>Note</span></b>
                  </xsl:variable><xsl:variable name="className19">VBORDER</xsl:variable><xsl:variable name="className20">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className19, ' ', $className20)" /><xsl:with-param name="rowspan">2</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7.1%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content10" /></xsl:call-template><xsl:variable name="content11">
                     <b><span>Exercice N</span></b>
                  </xsl:variable><xsl:variable name="className21">VBORDER</xsl:variable><xsl:variable name="className22">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className21, ' ', $className22)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">3</xsl:with-param><xsl:with-param name="width">12.2%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content11" /></xsl:call-template><xsl:variable name="content12">
                     <b><span>Exercice N-1</span></b>
                  </xsl:variable><xsl:variable name="className23">VBORDER</xsl:variable><xsl:variable name="className24">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className23, ' ', $className24)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">11.2%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content12" /></xsl:call-template></tr>
               <tr style="height:15.55pt"><xsl:variable name="varOdm3" select="$varOdm1"/><xsl:variable name="content13">
                     <b><span>BRUT</span></b>
                  </xsl:variable><xsl:variable name="className25">VBORDER</xsl:variable><xsl:variable name="className26">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className25, ' ', $className26)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">12.2%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content13" /></xsl:call-template><xsl:variable name="content14">
                     <b><span>amortissements, dépréciations</span></b>
                  </xsl:variable><xsl:variable name="className27">VBORDER</xsl:variable><xsl:variable name="className28">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className27, ' ', $className28)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">12.2%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content14" /></xsl:call-template><xsl:variable name="content15">
                     <b><span>NET</span></b>
                  </xsl:variable><xsl:variable name="className29">VBORDER</xsl:variable><xsl:variable name="className30">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className29, ' ', $className30)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">12.2%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content15" /></xsl:call-template><xsl:variable name="content16">
                     <b><span>NET</span></b>
                  </xsl:variable><xsl:variable name="className31">VBORDER</xsl:variable><xsl:variable name="className32">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className31, ' ', $className32)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">11.2%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content16" /></xsl:call-template></tr>
            </thead><xsl:variable name="varOdm4" select="$varOdm1"/><xsl:variable name="varOdm5"><xsl:for-each select="$varOdm4"><xsl:sort select="./dc:NumOrdre/@V" data-type="number"/><xsl:variable name="ligne" select="."/><tr><xsl:variable name="content17"><xsl:value-of select="distinct-values($ligne/dc:Intitule1/@V)"/></xsl:variable><xsl:variable name="className33" select="$ligne/dc:Format/@V"/><xsl:variable name="className34">LIBELLE</xsl:variable><xsl:variable name="className35">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className33, ' ', $className34, ' ', $className35)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">44.9%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content17" /></xsl:call-template><xsl:variable name="content18">
                  <span></span>
               </xsl:variable><xsl:variable name="className36" select="$ligne/dc:Format/@V"/><xsl:variable name="className37">LIBELLE</xsl:variable><xsl:variable name="className38">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className36, ' ', $className37, ' ', $className38)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7.1%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content18" /></xsl:call-template><xsl:variable name="content19"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/dc:MtBrut/@V"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:variable name="className39" select="$ligne/dc:Format/@V"/><xsl:variable name="className40">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className39, ' ', $className40)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">12.2%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content19" /></xsl:call-template><xsl:variable name="content20"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/dc:MtAmo/@V"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:variable name="className41" select="$ligne/dc:Format/@V"/><xsl:variable name="className42">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className41, ' ', $className42)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">12.2%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content20" /></xsl:call-template><xsl:variable name="content21"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/dc:MtNet/@V"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:variable name="className43" select="$ligne/dc:Format/@V"/><xsl:variable name="className44">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className43, ' ', $className44)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">12.2%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content21" /></xsl:call-template><xsl:variable name="content22"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/dc:MtNet-1/@V"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:variable name="className45" select="$ligne/dc:Format/@V"/><xsl:variable name="className46">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className45, ' ', $className46)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">11.2%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content22" /></xsl:call-template></tr></xsl:for-each></xsl:variable><xsl:variable name="varOdm6"><xsl:choose><xsl:when test="count($varOdm5/*) = 0"><tr class=" #tech#" style="height:15.55pt"><td height="1px" width="12.2%" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="12.2%" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="12.2%" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="11.2%" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td></tr></xsl:when><xsl:otherwise><xsl:sequence select="$varOdm5"></xsl:sequence></xsl:otherwise></xsl:choose></xsl:variable><xsl:call-template name="table:processRowStyled"><xsl:with-param name="borderStyle" select="'solid 1.0pt'"></xsl:with-param><xsl:with-param name="rows" select="$varOdm6/xhtml:tr"></xsl:with-param></xsl:call-template></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab3"></xsl:with-param></xsl:call-template>
         <xsl:variable name="varOdmTmpTab4"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none"><tr><xsl:variable name="varOdm7" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="100%" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1"><p style="punctuation-wrap:simple"><xsl:if test="not($varOdm7/dc:NumOrdre/@V and $varOdm7/dc:Etat/@V='BI_A')">Cet état ne contient pas d'information.</xsl:if></p></td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab4"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"> </p>
         <xsl:variable name="varOdmTmpTab5"><table width="100%" class="MsoNormalTable " border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse"><xsl:variable name="varOdm8" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable[(./dc:ModeTraitement/@V='NOTE_BAS_PAGE') and (./dc:Etat/@V='BI_A')]"/><tr><td width="100%" valign="top" style="padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1">
                  <p class="MsoNormal" style="line-height:115%;layout-grid-mode:char;punctuation-wrap: simple"><span style="font-size:6.0pt;line-height:115%"></span></p>
               </td></tr><xsl:variable name="varOdm9" select="$varOdm8"/><xsl:variable name="varOdm10"><xsl:for-each select="$varOdm9"><xsl:sort select="./dc:NumOrdre/@V" data-type="number"/><xsl:variable name="ligne" select="."/><tr><xsl:variable name="content23"><xsl:value-of select="distinct-values($ligne/dc:NoteBasTableau/@V)"/></xsl:variable><xsl:variable name="className47" select="$ligne/dc:Format/@V"/><xsl:variable name="className48">FONT6</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className47, ' ', $className48)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">100%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content23" /></xsl:call-template></tr></xsl:for-each></xsl:variable><xsl:variable name="varOdm11"><xsl:choose><xsl:when test="count($varOdm10/*) = 0"><tr class=" #tech#"><td height="1px" width="100%" valign="top" rowspan="1" colspan="1" style="padding:2.75pt 2.75pt 2.75pt 2.75pt"></td></tr></xsl:when><xsl:otherwise><xsl:sequence select="$varOdm10"></xsl:sequence></xsl:otherwise></xsl:choose></xsl:variable><xsl:call-template name="table:processRowStyled"><xsl:with-param name="borderStyle" select="'solid 1.0pt'"></xsl:with-param><xsl:with-param name="rows" select="$varOdm11/xhtml:tr"></xsl:with-param></xsl:call-template></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab5"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal" style="margin-bottom:10.0pt;line-height:115%;page-break-before:always"><span style="font-size:4.0pt;line-height:115%"> </span></p>
         <xsl:variable name="varOdmTmpTab6"><table width="100%" class="MsoNormalTable " border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse"><tr><td width="90%" valign="top" style="border:solid black 1.0pt; border-right:none;padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><b>III – ÉTATS FINANCIERS</b></p>
               </td><td width="10%" valign="top" style="border:solid black 1.0pt; padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><b>III</b></p>
               </td></tr><tr><td width="90%" valign="top" style="border-top:none;border-left: solid black 1.0pt;border-bottom:solid black 1.0pt;border-right:none; padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><b><span style="line-height:115%">Bilan (en euros)</span></b></p>
               </td><td width="10%" valign="top" style="border:solid black 1.0pt; border-top:none;padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><b><span style="line-height:115%">A</span></b></p>
               </td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab6"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal" style="punctuation-wrap:simple"><span style="font-size:11.0pt"> </span></p>
         <xsl:variable name="varOdmTmpTab7"><table width="100%" class="MsoNormalTable BORDURE" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse"><xsl:variable name="varOdm12" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable[(./dc:Etat/@V='BI_P') and (./dc:ModeTraitement/@V!='NOTE_BAS_PAGE')]"/><thead>
               <tr style="height:15.55pt"><xsl:variable name="varOdm13" select="$varOdm12"/><xsl:variable name="content24">
                     <span><b>FONDS PROPRES ET PASSIF</b></span>
                     <span></span>
                  </xsl:variable><xsl:variable name="className49">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className49" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">45%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content24" /></xsl:call-template><xsl:variable name="content25">
                     <b><span>Note</span></b>
                  </xsl:variable><xsl:variable name="className50">VBORDER</xsl:variable><xsl:variable name="className51">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className50, ' ', $className51)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content25" /></xsl:call-template><xsl:variable name="content26">
                     <b><span>Exercice N</span></b>
                  </xsl:variable><xsl:variable name="className52">VBORDER</xsl:variable><xsl:variable name="className53">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className52, ' ', $className53)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">24%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content26" /></xsl:call-template><xsl:variable name="content27">
                     <b><span>Exercice N-1</span></b>
                  </xsl:variable><xsl:variable name="className54">VBORDER</xsl:variable><xsl:variable name="className55">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className54, ' ', $className55)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">24%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content27" /></xsl:call-template></tr>
            </thead><xsl:variable name="varOdm14" select="$varOdm12"/><xsl:variable name="varOdm15"><xsl:for-each select="$varOdm14"><xsl:sort select="./dc:NumOrdre/@V" data-type="number"/><xsl:variable name="ligne" select="."/><tr><xsl:variable name="content28"><xsl:value-of select="distinct-values($ligne/dc:Intitule1/@V)"/></xsl:variable><xsl:variable name="className56" select="$ligne/dc:Format/@V"/><xsl:variable name="className57">LIBELLE VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className56, ' ', $className57)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">45%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content28" /></xsl:call-template><xsl:variable name="content29">
                  <span></span>
               </xsl:variable><xsl:variable name="className58" select="$ligne/dc:Format/@V"/><xsl:variable name="className59">LIBELLE VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className58, ' ', $className59)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content29" /></xsl:call-template><xsl:variable name="content30"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/dc:MtNet/@V"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:variable name="className60" select="$ligne/dc:Format/@V"/><xsl:variable name="className61">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className60, ' ', $className61)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">24%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content30" /></xsl:call-template><xsl:variable name="content31"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/dc:MtNet-1/@V"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:variable name="className62" select="$ligne/dc:Format/@V"/><xsl:variable name="className63">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className62, ' ', $className63)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">24%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content31" /></xsl:call-template></tr></xsl:for-each></xsl:variable><xsl:variable name="varOdm16"><xsl:choose><xsl:when test="count($varOdm15/*) = 0"><tr class=" #tech#" style="height:15.55pt"><td height="1px" width="45%" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="7%" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="24%" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="24%" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td></tr></xsl:when><xsl:otherwise><xsl:sequence select="$varOdm15"></xsl:sequence></xsl:otherwise></xsl:choose></xsl:variable><xsl:call-template name="table:processRowStyled"><xsl:with-param name="borderStyle" select="'solid 1.0pt'"></xsl:with-param><xsl:with-param name="rows" select="$varOdm16/xhtml:tr"></xsl:with-param></xsl:call-template></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab7"></xsl:with-param></xsl:call-template>
         <xsl:variable name="varOdmTmpTab8"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none"><tr><xsl:variable name="varOdm17" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="100%" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1"><p style="punctuation-wrap:simple"><xsl:if test="not($varOdm17/dc:NumOrdre/@V and $varOdm17/dc:Etat/@V='BI_P')">Cet état ne contient pas d'information.</xsl:if></p></td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab8"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"> </p>
         <xsl:variable name="varOdmTmpTab9"><table width="100%" class="MsoNormalTable " border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse"><xsl:variable name="varOdm18" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable[(./dc:ModeTraitement/@V='NOTE_BAS_PAGE') and (./dc:Etat/@V='BI_P')]"/><tr><td width="100%" valign="top" style="padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1">
                  <p class="MsoNormal" style="line-height:115%;layout-grid-mode:char;punctuation-wrap: simple"><span style="font-size:6.0pt;line-height:115%"></span></p>
               </td></tr><xsl:variable name="varOdm19" select="$varOdm18"/><xsl:variable name="varOdm20"><xsl:for-each select="$varOdm19"><xsl:sort select="./dc:NumOrdre/@V" data-type="number"/><xsl:variable name="ligne" select="."/><tr><xsl:variable name="content32"><xsl:value-of select="distinct-values($ligne/dc:NoteBasTableau/@V)"/></xsl:variable><xsl:variable name="className64" select="$ligne/dc:Format/@V"/><xsl:variable name="className65">FONT6</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className64, ' ', $className65)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">100%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content32" /></xsl:call-template></tr></xsl:for-each></xsl:variable><xsl:variable name="varOdm21"><xsl:choose><xsl:when test="count($varOdm20/*) = 0"><tr class=" #tech#"><td height="1px" width="100%" valign="top" rowspan="1" colspan="1" style="padding:2.75pt 2.75pt 2.75pt 2.75pt"></td></tr></xsl:when><xsl:otherwise><xsl:sequence select="$varOdm20"></xsl:sequence></xsl:otherwise></xsl:choose></xsl:variable><xsl:call-template name="table:processRowStyled"><xsl:with-param name="borderStyle" select="'solid 1.0pt'"></xsl:with-param><xsl:with-param name="rows" select="$varOdm21/xhtml:tr"></xsl:with-param></xsl:call-template></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab9"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal" style="punctuation-wrap:simple"><span style="font-size:4.0pt"> </span></p>
         <p class="MsoNormal"> </p>
      </div>
   </body><script type="text/javascript">
            function iframeLoadPage(href) {
            try {
            parent.loadPage(href);
            } catch(ex) {
            //si on n'arrive pas a acceder a la page parente
            document.location.href = href;
            }
            }
            function scrollToElementId(elementId) {
            document.getElementById(elementId).scrollIntoView();
            }
        </script>
</html></xsl:template></xsl:stylesheet>